"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullLeaderboardAnimations = void 0;
const LeaderboardConstants_1 = require("./Interfaces/LeaderboardConstants");
class FullLeaderboardAnimations {
    constructor(mainScreenTransform, previewScreenTransform, topBorderScreenTransform, roundedCornersTransform, previewParentScreenTransform) {
        this.mainScreenTransform = mainScreenTransform;
        this.previewScreenTransform = previewScreenTransform;
        this.topBorderScreenTransform = topBorderScreenTransform;
        this.roundedCornersTransform = roundedCornersTransform;
        this.previewParentScreenTransform = previewParentScreenTransform;
        this.animationTween = null;
        this.isScreenTextureInPreview = null;
    }
    setIsScreenTextureInPreview(isScreenTex) {
        this.isScreenTextureInPreview = isScreenTex;
    }
    isPlaying() {
        if (isNull(this.animationTween)) {
            return false;
        }
        if (isNull(this.animationTween.isPlaying)) {
            return false;
        }
        return this.animationTween.isPlaying();
    }
    forceStopAnimationIfPlaying() {
        if (!isNull(this.animationTween)) {
            try {
                this.animationTween.stop();
                TWEEN.remove(this.animationTween);
            }
            catch (e) { }
        }
    }
    playAnimation(toShow, onComplete) {
        const startPos = this.mainScreenTransform.anchors.getCenter();
        const endPos = toShow ? new vec2(0, 0) : new vec2(0, -2);
        const duration = startPos.distance(endPos) * LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.ANIMATION_DURATION_MS / 2;
        if (duration === 0) {
            return;
        }
        this.forceStopAnimationIfPlaying();
        const startRect = this.previewScreenTransform.anchors;
        const endRect = toShow ? LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.CUSTOM_TEXTURE_END_RECT
            : LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.CUSTOM_TEXTURE_START_RECT;
        const parentStartRect = this.previewParentScreenTransform.anchors;
        const parentEndRect = toShow ? LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.CUSTOM_TEXTURE_PARENT_END_RECT
            : LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.CUSTOM_TEXTURE_PARENT_START_RECT;
        const topBorderBottomStartValue = this.topBorderScreenTransform.anchors.bottom;
        const topBorderBottomEndValue = toShow ? LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.TOP_BORDER_BOTTOM_END_VALUE
            : LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.TOP_BORDER_BOTTOM_START_VALUE;
        const roundCornersScaleStartValue = this.roundedCornersTransform.getLocalScale().x;
        const roundCornersScaleEndValue = toShow ? LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.ROUND_CORNER_SCALE_X_END_VALUE
            : LeaderboardConstants_1.LeaderboardConstants.FullLeaderboard.ROUND_CORNER_SCALE_X_START_VALUE;
        const from = {
            y: startPos.y,
            topBorderBottom: topBorderBottomStartValue,
            roundCornersScale: roundCornersScaleStartValue
        };
        const to = {
            y: endPos.y,
            topBorderBottom: topBorderBottomEndValue,
            roundCornersScale: roundCornersScaleEndValue
        };
        this.enrichObjectWithRect(from, startRect, "customTexture");
        this.enrichObjectWithRect(to, endRect, "customTexture");
        this.enrichObjectWithRect(from, parentStartRect, "customTextureParent");
        this.enrichObjectWithRect(to, parentEndRect, "customTextureParent");
        this.animationTween = new TWEEN.Tween(from)
            .to(to, duration)
            .onUpdate((obj) => {
            this.mainScreenTransform.anchors.setCenter(new vec2(0, obj.y));
            if (this.isScreenTextureInPreview) {
                this.previewScreenTransform.anchors = this.constructRectWithPrefix(obj, "customTexture");
                this.previewParentScreenTransform.anchors = this.constructRectWithPrefix(obj, "customTextureParent");
            }
            this.topBorderScreenTransform.anchors.bottom = obj.topBorderBottom;
            this.roundedCornersTransform.setLocalScale(new vec3(obj.roundCornersScale, 1, 1));
        })
            .easing(TWEEN.Easing.Quadratic.InOut)
            .onComplete(onComplete)
            .start();
    }
    enrichObjectWithRect(obj, rect, prefix) {
        obj[prefix + "left"] = rect.left;
        obj[prefix + "right"] = rect.right;
        obj[prefix + "bottom"] = rect.bottom;
        obj[prefix + "top"] = rect.top;
    }
    constructRectWithPrefix(obj, prefix) {
        return Rect.create(obj[prefix + "left"], obj[prefix + "right"], obj[prefix + "bottom"], obj[prefix + "top"]);
    }
}
exports.FullLeaderboardAnimations = FullLeaderboardAnimations;
//# sourceMappingURL=FullLeaderboardAnimations.js.map